% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testGlasso.R
\name{testGlasso}
\alias{testGlasso}
\title{Test for for the equality of connectivity based on the Graphical lasso estimation.}
\usage{
testGlasso(
  subY1,
  subY2,
  p,
  lambda = "bic",
  nboot = 100,
  n.cl,
  bound = c(0.001, 1),
  gridTF = FALSE
)
}
\arguments{
\item{subY1}{a sample of size length*dim}

\item{subY2}{a sample of size length*dim}

\item{p}{Gep(p) distribution controls the size of stationary bootstrap. The mean block length is 1/p}

\item{lambda}{two selections possible for optimal parameter of lambda. "bic" finds lambda from bic criteria, or user can directly input the penalty value.}

\item{nboot}{the number of bootstrap sample for p-value. Default is 100.}

\item{n.cl}{number of cores in parallel computing. The default is (machine cores - 1)}

\item{bound}{bound of bic search in "bic" rule. Default is (.001, 1)}

\item{gridTF}{Utilize a grid search to optimize hyperparameters}
}
\value{
\strong{pval} The empirical p-value for testing the equality of connectivity structure

\strong{rho} The sequence of penalty parameter based on the combined sample, subY1 and subY2.

\strong{fit0} Output of glasso for combined sample

\strong{fit1} Output of glasso for subY1

\strong{fit2} Output of glasso for subY2
}
\description{
This function utilizes Dynamic Connectivity Regression (DCR) algorithm proposed by Cribben el al. (2012) to test the equality of connectivity in two fMRI signals.
}
\examples{
test1= testGlasso(testsim$X, testsim$Y, n.cl=1)
}
