% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFuncs.R
\name{checkLength}
\alias{checkLength}
\title{Checking if the length of the different elements of a list corresponds to what one expects.}
\usage{
checkLength(listObjects, lengthObjects)
}
\arguments{
\item{listObjects}{List of vectors, of irrespective data type.}

\item{lengthObjects}{Numeric vector, either of the same length as the 'listObjects' argument, or of length 1, but in the latter case, it will be tested whether or not the length of every element of the 'listObjects' argument equal this one value.}
}
\value{
No value is returned if all vectors correspond to the length against which it is tested. An error message is thrown when the length does not corresponds for at least one element of the list.
}
\description{
Checking if the length of the different elements of a list corresponds to what one expects.
}
\examples{
arg1 <- 'something'
checkLength(list(arg1), 1)

checkLength(list('somethingElse', TRUE), 1)
checkLength(list('somethingElse', TRUE), c(1, 1))

arg2 <- 2:5
checkLength(list(arg1, arg2), c(1, 4))
\donttest{checkLength(list(arg1, arg2), 1)}
}
