% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standards.R
\name{standards_3dc}
\alias{standards_3dc}
\alias{coef.sts_par}
\alias{plot.sts_par}
\title{Standard setting}
\usage{
standards_3dc(parms, design)

\method{coef}{sts_par}(object, ...)

\method{plot}{sts_par}(x, booklet_id = NULL, ...)
}
\arguments{
\item{parms}{parameters object returned from fit_enorm}

\item{design}{a data.frame with columns `cluster_id`, `item_id` and optionally `booklet_id`}

\item{object}{an object containing parameters for the 3DC standard setting procedure}

\item{...}{ignored
Optionally you can include a column `booklet_id` to specify multiple test forms for standard setting and/or
columns `cluster_nbr` and `item_nbr` to specify ordering of clusters and items in the forms and application.}

\item{x}{an object containing parameters for the 3DC standard setting procedure}

\item{booklet_id}{which test form to plot}
}
\value{
an object of type `sts_par`
}
\description{
Set performance standards on one or more test forms using the data driven direct consensus (3DC) method
}
\details{
The data driven direct consensus (3DC) method of standard setting was invented by Gunter Maris and described in Keuning et. al. (2017).
To easily apply this procedure, we advise to use the free digital 3DC application. This application 
can be downloaded from the Cito website, see the 
\href{https://cito.com/what-we-do/support/3dc}{3DC application download page}. 
If you want to apply the 3DC method using paper forms instead, you can use the plot method to generate the forms
from the sts_par object.

Although the 3DC method is used as explained in Keuning et. al., the method we use for computing the forms is a simple
maximum likelihood scaling from an IRT model, described in Moe and Verhelst (2017)
}
\examples{

\dontshow{ RcppArmadillo::armadillo_throttle_cores(1)}

library(dplyr)
db = start_new_project(verbAggrRules, ":memory:")
            
add_booklet(db, verbAggrData, "agg")
add_item_properties(db, verbAggrProperties)

design = get_items(db) |>
  rename(cluster_id='behavior')

f = fit_enorm(db)

sts_par = standards_3dc(f, design)

plot(sts_par)


# db_sts = standards_db(sts_par,'test.db',c('mildly aggressive','dangerously aggressive'))

\dontshow{ RcppArmadillo::armadillo_reset_cores()}

}
\references{
Keuning J., Straat J.H., Feskens R.C.W. (2017) The Data-Driven Direct Consensus (3DC) Procedure: A New Approach to Standard Setting. 
In: Blomeke S., Gustafsson JE. (eds) Standard Setting in Education. 
Methodology of Educational Measurement and Assessment. Springer, Cham

Moe E., Verhelst N. (2017) Setting Standards for Multistage Tests of Norwegian for Adult Immigrants 
In: Blomeke S., Gustafsson JE. (eds) Standard Setting in Education. 
Methodology of Educational Measurement and Assessment. Springer, Cham
}
\seealso{
how to make a database for the 3DC standard setting application: \code{\link{standards_db}}
}
