% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernstein_mechanism.R
\docType{class}
\name{DPMechBernstein-class}
\alias{DPMechBernstein-class}
\alias{DPMechBernstein}
\alias{show,DPMechBernstein-method}
\alias{releaseResponse,DPMechBernstein,DPParamsEps-method}
\alias{sensitivityNorm,DPMechBernstein-method}
\title{An S4 class for the Bernstein mechanism of differential privacy.}
\usage{
\S4method{show}{DPMechBernstein}(object)

\S4method{releaseResponse}{DPMechBernstein,DPParamsEps}(mechanism,
  privacyParams, X)

\S4method{sensitivityNorm}{DPMechBernstein}(mechanism, X1, X2)
}
\arguments{
\item{object}{an instance of class \code{DPMech}.}

\item{mechanism}{an object of class \code{\link{DPMechBernstein}}.}

\item{privacyParams}{an object of class \code{\link{DPParamsEps}}.}

\item{X}{a privacy-sensitive dataset, if using sensitivity sampler a: list,
matrix, data frame, numeric/character vector.}

\item{X1}{a privacy-sensitive dataset.}

\item{X2}{a privacy-sensitive dataset.}
}
\value{
list with slots per argument, actual privacy parameter and response:
  mechanism response with length of target release:
  \code{privacyParams, sensitivity, latticeK, dims, target, response}.

scalar numeric norm of non-private \code{target} on datasets.
  The \eqn{L_\infty} of the functions on a lattice.
}
\description{
A class that implements the Bernstein mechanism (not iterated version) of
differential privacy, for privatizing release of real-valued functions on
\eqn{[0,1]^l} based on arbitrary datasets. Approximates the \code{target}
on a lattice.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: automatically prints the object.

\item \code{releaseResponse}: releases Bernstein mechanism responses.

\item \code{sensitivityNorm}: measures \code{target} sensitivity.
}}

\section{Slots}{

\describe{
\item{\code{sensitivity}}{non-negative scalar numeric maximum absolute \code{target}
sensitivity maximized over the lattice. Defaults to \code{Inf} for use
with \code{sensitivitySampler()}.}

\item{\code{target}}{might be a closure that takes arbitrary dataset and returns a
real-valued function on \eqn{[0,1]^l}.}

\item{\code{gammaSensitivity}}{\code{NA_real_} if inactive, or scalar in [0,1)
indicating that responses must be RDP with specific confidence.}

\item{\code{latticeK}}{positive scalar integer-valued numeric specifying the lattice
resolution. Defaults to (invalid) \code{NA_integer_}.}

\item{\code{dims}}{positive scalar integer-valued numeric specifying the dimension
of released function domain. Defaults to (invalid) \code{NA_integer_}.}
}}

\examples{
## See the bernstein vignette

}
\references{
Francesco Aldà and Benjamin I. P. Rubinstein. "The Bernstein Mechanism:
  Function Release under Differential Privacy", in Proceedings of the 31st
  AAAI Conference on Artificial Intelligence (AAAI'2017), pp. 1705-1711,
  Feb 2017.
}
