% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_sampler.R
\docType{methods}
\name{sensitivitySampler,DPMech,function,numeric-method}
\alias{sensitivitySampler,DPMech,function,numeric-method}
\title{Sensitivity sampler for \code{\link{DPMech-class}}'s.}
\usage{
\S4method{sensitivitySampler}{DPMech,`function`,numeric}(object, oracle, n,
  m = NA_integer_, gamma = NA_real_)
}
\arguments{
\item{object}{an object of class \code{\link{DPMech-class}}.}

\item{oracle}{a source of random databases. A function returning: list,
matrix/data.frame (data in rows), numeric/character vector of records if
given desired length > 1; or single record given length 1, respectively
a list element, a row/named row,  a single numeric/character. Whichever
type is used should be expected by \code{object@target}.}

\item{n}{database size scalar positive numeric, integer-valued.}

\item{m}{sensitivity sample size scalar positive numeric, integer-valued.}

\item{gamma}{RDP privacy confidence level.}
}
\value{
\code{object} with updated \code{gammaSensitivity} slot.
}
\description{
Given a constructed \code{\link{DPMech-class}}, complete with \code{target}
function and \code{sensitivityNorm,} and an \code{oracle} for producing
records, samples the sensitivity of the target function to set the
mechanism's \code{sensitivity}.
}
\examples{
## Simple example with unbounded data hence no global sensitivity.
f <- function(xs) mean(xs)
m <- DPMechLaplace(target = f, dims = 1)
m@sensitivity ## Inf
m@gammaSensitivity ## NA as Laplace is naturally eps-DP
P <- function(n) rnorm(n)
m <- sensitivitySampler(m, oracle = P, n = 100, gamma = 0.33)
m@sensitivity ## small like 0.03...
m@gammaSensitivity ## 0.33 as directed, now m is (eps,gam)-DP.

}
\references{
Benjamin I. P. Rubinstein and Francesco Aldà. "Pain-Free Random Differential
  Privacy with Sensitivity Sampling", accepted into the 34th International
  Conference on Machine Learning (ICML'2017), May 2017.
}
