% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dipw.R
\name{dipw.mean}
\alias{dipw.mean}
\title{Estimation of E[Y(1)] or E[Y(0)] from observational data}
\usage{
dipw.mean(
  X,
  Y,
  W,
  Treated = TRUE,
  r = NULL,
  kappa = 0.5,
  splitting = c("1", "3", "random"),
  B = 1,
  ...
)
}
\arguments{
\item{X}{the n by p input covariance matrix}

\item{Y}{the n dimensional observed response}

\item{W}{the n dimensional binary vector indicating treatment assignment}

\item{Treated}{\code{TRUE} if we seek to estimate E[Y(1)], \code{FALSE} if we instead wish
to estimate E[Y(0)]. The default is TRUE}

\item{r}{optional n dimensional vector containing initial estimates of
E[Y(\code{Treated}) | X_i] for i = 1, ..., n. The default is NULL}

\item{kappa}{the weight parameter for quadratic programming. Default is 0.5}

\item{splitting}{the options for splitting. "1" means B = 1 split, "3"
means B = 3 splits, "random" means random splits.}

\item{B}{the number of iterations for random splits, the default is 1.
Only valid when splitting is set to "random".}

\item{\dots}{additional arguments that can be passed to \code{\link[glmnet]{cv.glmnet}}}
}
\value{
the expectation E[Y(1)] or E[Y(0)]
}
\description{
Estimation of E[Y(1)] or E[Y(0)] from observational data
}
\examples{
\dontrun{
# Estimating mean of the potential outcome with a toy data
# Notice that the external optimisation software \code{MOSEK}
# must be installed separately before running the example code.
# Without \code{MOSEK}, the example code is not executable.
# For how to install \code{MOSEK}, see documentation of \code{\link[Rmosek]{Rmosek}}.
set.seed(1)
n <- 100; p <- 200
X <- scale(matrix(rnorm(n*p), n, p))
W <- rbinom(n, 1, 1 / (1 + exp(-X[, 1])))
Y <- X[,1] + W * X[,2] + rnorm(n)
# Getting an estimate of potential outcome mean
(est <- dipw.mean(X, Y, W, Treated=TRUE))
}
}
\references{
Wang, Y., Shah, R. D. (2020) \emph{Debiased inverse propensity
score weighting for estimation of average treatment effects with high-dimensional
confounders} \url{https://arxiv.org/abs/2011.08661}
}
