% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvLifeTable.R
\name{lifeTable}
\alias{lifeTable}
\alias{print.discSurvLifeTable}
\title{Life Table Construction and Estimates}
\usage{
lifeTable(dataShort, timeColumn, eventColumn, intervalLimits = NULL)

\method{print}{discSurvLifeTable}(x, ...)
}
\arguments{
\item{dataShort}{Original data in short format ("class data.frame").}

\item{timeColumn}{Name of the column with discrete survival times ("character vector").}

\item{eventColumn}{Gives the column name of the event indicator (1=observed,
0=censored) ("character vector").}

\item{intervalLimits}{Optional names of the intervals for each row, e. g.
[a_0, a_1), [a_1, a_2), ..., [a_{q-1}, a_q) ("character vector")}

\item{x}{Object of class "discSurvLifeTable"("class discSurvLifeTable")}

\item{\dots}{Additional arguments to the print function}
}
\value{
List containing an object of class "data.frame" with following
columns \itemize{ \item{n} Number of individuals at risk in a given time
interval (integer) \item{events} Observed number of events in a given time
interval (integer) \item{dropouts} Observed number of dropouts in a given
time interval (integer) \item{atRisk} Estimated number of individuals at
risk, corrected by dropouts (numeric) \item{hazard} Estimated risk of death
(without covariates) in a given time interval \item{seHazard} Estimated
standard deviation of estimated hazard \item{S} Estimated survival curve
\item{seS} Estimated standard deviation of estimated survival function
\item{cumHazard} Estimated cumulative hazard function \item{seCumHazard}
Estimated standard deviation of the estimated cumulative hazard function
\item{margProb} Estimated marginal probability of event in time interval }
}
\description{
Constructs a life table and estimates discrete hazards, survival
functions, discrete cumulative hazards and their standard errors without
covariates.
}
\examples{

# Example with unemployment data
library(Ecdat)
data(UnempDur)

# Extract subset of all persons smaller or equal the median of age
UnempDurSubset <- subset(UnempDur, age <= median(UnempDur$age))
LifeTabUnempDur <- lifeTable(dataShort = UnempDurSubset, timeColumn = "spell", 
eventColumn = "censor1")
LifeTabUnempDur

# Example with monoclonal gammapothy data
library(survival)
head(mgus)

# Extract subset of mgus
subMgus <- mgus [mgus$futime<=median(mgus$futime), ]

# Transform time in days to intervals [0, 1), [1, 2), [2, 3), ... , [12460, 12461)
mgusInt <- subMgus
mgusInt$futime <- mgusInt$futime + 1
LifeTabGamma <- lifeTable(dataShort = mgusInt, timeColumn= "futime", eventColumn = "death")
head(LifeTabGamma$Output, 25)
plot(x = 1:dim(LifeTabGamma$Output)[1], y = LifeTabGamma$Output$hazard, type = "l", 
xlab = "Time interval", ylab = "Hazard", las = 1, 
main = "Life table estimated marginal discrete hazards")

}
\references{
\insertRef{tutzModelDisc}{discSurv} \cr\cr
\insertRef{lawlessLifetime}{discSurv}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}

Matthias Schmid \email{matthias.schmid@imbie.uni-bonn.de}
}
\keyword{survival}
