% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvTreeLaplaceHazards_ranger.R
\name{survTreeLaplaceHazardRanger}
\alias{survTreeLaplaceHazardRanger}
\title{Laplace Hazards for a Competing Risk Survival Tree Object}
\usage{
survTreeLaplaceHazardRanger(treeModel, rangerdata, newdata, lambda)
}
\arguments{
\item{treeModel}{Fitted tree object as generated by "ranger" ("class data.frame"). Must be a single ranger tree.}

\item{rangerdata}{Original training data with which \emph{treeModel} was fitted ("class data.frame"). Must be in
long format.}

\item{newdata}{Data in long format for which hazards are to be computed ("class data.frame"). Must 
contain the same columns that were used for tree fitting.}

\item{lambda}{Smoothing parameter for laplace-smoothing ("class data.frame"). Must be a non-negative 
number. A value of zero corresponds to no smoothing.}
}
\value{
A m by k matrix with m being the length of newdata and k being the 
number of classes in \emph{treeModel}. Each row corresponds to the smoothed hazard 
of the respective observation.
}
\description{
Predicts the laplace-smoothed hazards of discrete survival data based
on a survival tree from class "ranger". Currently only single-risk data is supported.
}
\examples{
library(pec)
library(caret)
library(ranger)
data(cost)
# Take subsample and convert time to years
cost$time <- ceiling(cost$time/365)
costSubTrain <- cost[1:50,]
costSubTest <- cost[51:70,]
# Specify column names for data augmentation
timeColumn<-"time"
eventColumn<-"status"
costSubTrainLong <- dataLong(costSubTrain, timeColumn, eventColumn)
costSubTestLong <- dataLong(costSubTest, timeColumn, eventColumn)
#create tree
formula <- y ~ timeInt + diabetes + prevStroke + age + sex
rangerTree <- ranger(formula, costSubTrainLong, num.trees = 1, mtry = 5, 
classification = TRUE, splitrule = "hellinger", replace = FALSE, 
sample.fraction = 1, max.depth = 5)
#compute laplace-smoothed hazards
laplHaz <- survTreeLaplaceHazardRanger(rangerTree, costSubTrainLong, 
costSubTestLong, lambda = 1)
laplHaz
}
\keyword{survival}
