% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_npdf.R
\name{sim_npdf}
\alias{sim_npdf}
\title{Simulation of grouped time-to-event data with nonparametric baseline hazard and discrete shared frailty distribution}
\usage{
sim_npdf(J, N = NULL, beta, Lambda_0_inv, p, w_values, cens_perc)
}
\arguments{
\item{J}{number of groups in the data}

\item{N}{number of individuals in each group}

\item{beta}{vector of log hazard ratios}

\item{Lambda_0_inv}{inverse cumulative baseline hazard function, that is, with covariate values 0 and frailty ratio 1}

\item{p}{vector of K elements.  The kth element gives the proportion of groups in the kth latent population of groups.}

\item{w_values}{vector of K distinct frailty values, one for each latent population.}

\item{cens_perc}{percentage of censored events. Censoring times are assumed to be distributed as a Normal with variance equal to 1.}
}
\value{
A data frame with one row for each simulated individual, and the following columns:

\code{family}: the group which the individual is in (integers 1, 2, ...)

\code{time}: the simulated event time.

\code{status}: the simulated survival status. Censoring times are generated from a Normal distribution with standard deviation equal to 1 and the mean is estimated in order to guarantee the determined percentage of censored events. The event time is observed (status=1) if it is less than the censoring time, and censored otherwise (status=0).

\code{x}: matrix of covariate values, generated from a standard normal distribution.

\code{belong}:  the frailty hazard ratio corresponding to the cluster of groups in which the individual's group has been allocated.
}
\description{
This function returns a dataset generated from a semiparametric proportional hazards model with a shared discrete frailty term, for given cumulative baseline hazard function, hazard ratios, distribution of groups among latent populations, frailty values for each latent population, and randomly-generated covariate values.
}
\examples{
J <- 100
N <- 40
Lambda_0_inv = function( t, c=0.01, d=4.6 ) ( t^( 1/d ) )/c
beta <- 1.6
p <- c( 0.8, 0.2 )
w_values <- c( 0.8, 1.6 )
cens_perc <- 0.1
data <- sim_npdf( J, N, beta, Lambda_0_inv, p, w_values, cens_perc )
head( data )
}
\references{
Wan, F. (2017). Simulating survival data with predefined censoring rates for proportional hazards models. \emph{Statistics in medicine}, 36(5), 838-854.
}
