% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{weibdata2030}
\alias{weibdata2030}
\title{Hierarchical time-to-event data simulated from a Weibull baseline distribution with a nonparametric frailty}
\format{
A data frame with 600 rows and the following columns

\describe{
\item{family}{Integer from 1 to 20 indicating the group membership. Each group has 30 individuals.}
\item{time}{Survival time}
\item{status}{Indicator for an observed event at the survival time}
\item{x}{Covariate value, generated from a standard normal distribution}
\item{belong}{Underlying group-specific frailty value}
}

There are two underlying latent populations with proportion 0.3 and 0.7 with frailty values 0.8 and 1.6 respectively, thus the second population has twice the hazard of the first.  The covariate is associated with a log hazard ratio of 1.6.

The baseline hazard is set to that of a Weibull model.

The percentage of censored events is equal to 10.

The dataset was generated by \code{\link{sim_weibdf}} as follows.

\code{sim_weibdf( J = 20, N = 30, lambda = 0.6, rho = 1.1, beta = 1.6, p = c( 0.3, 0.7 ), w_values = c( 0.8, 1.6 ), cens_perc = 0.1)}
}
\usage{
weibdata2030
}
\description{
Hierarchical time-to-event data simulated from a Weibull baseline distribution with a nonparametric frailty
}
\keyword{datasets}
