% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLSAM.R
\name{getLSAM}
\alias{getLSAM}
\title{Low Spectral Anomaly Mangitude (LSAM)}
\usage{
getLSAM(resid, years, for.year = NULL)
}
\arguments{
\item{resid}{A vector of residual values generated with respect to the baseline signal}

\item{years}{A vector of years corrosponding to the residual values}

\item{for.year}{(optional) Calculate LSAM values only for the given year in this argument.
If argument is omitted, LSAM values for all years are calculated.}
}
\value{
Data frame containing four columns:
\tabular{ll}{
\code{year} \tab First column, represents year \cr
\code{LSAM} \tab Second column, represents LSAM values \cr
\code{index.year} \tab Third column, representing index of LSAM value in that \code{year} \cr
\code{index.all} \tab Fourth column, representing index of LSAM value in the input \code{resid} \cr
}
}
\description{
Compute Low Spectral Anomaly Magnitude (LSAM) from the given residual values each year
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# LSAM
lsam = getLSAM(x.bl$resid.sig, x.streamflow$data$year)

}
