% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNAA.R
\name{getNAA}
\alias{getNAA}
\title{Net Annual Anomaly (NAA)}
\usage{
getNAA(resid, years, for.year = NULL)
}
\arguments{
\item{resid}{A vector of residual values generated with respect to the baseline signal}

\item{years}{A vector of years corrosponding to the residual values}

\item{for.year}{(optional) Calculate NAA values only for the given year in this argument.
If argument is omitted, NAA values for all years are calculated.}
}
\value{
Data frame containing two columns: 
\tabular{ll}{
\code{year} \tab First column, represents year \cr
\code{NAA} \tab Second column, represents NAA values
}
}
\description{
Calculate Net Annual Anomaly (NAA) from the given residual values.
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# NAA
naa = getNAA(x.bl$resid.sig, x.streamflow$data$year)

}
