% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTimingLSAM.R
\name{getTimingLSAM}
\alias{getTimingLSAM}
\title{Time of occurence of Low Spectral Anomaly Magnitude (LSAM)}
\usage{
getTimingLSAM(index.lsam, index.ref, years = NULL, for.year = NULL)
}
\arguments{
\item{index.lsam}{A scalar/vector of index of LSAM values in given year/years}

\item{index.ref}{A scalar/vector of index of reference point in given year/years}

\item{years}{(optional) A vector of years corresponding to LSAM and ref values.
This argument can be NULL if the LSAM and ref values are scalars.}

\item{for.year}{(optional) Calculate timing (LSAM) only for the given year in this argument.
If argument is omitted, timing (LSAM) values for all years are calculated.}
}
\value{
Scalar timing LSAM value if the inputs are scalars, or a Data frame containing two Columns:
\tabular{ll}{
\code{year} \tab First column, represents year \cr
\code{timing.lsam} \tab Second column, represents lsam timing values
}
}
\description{
Compute the number of days separating LSAM and reference point for each year.
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# get signal parts
x.sp = getSignalParts(x.bl$pred2, candmin = c(40:125), candmax = c(190:330),
                      years = x.streamflow$data$year, 
                      months = x.streamflow$data$month,
                      jdays = x.streamflow$data$jday)

# get LSAM values
lsam = getLSAM(x.bl$resid.sig, x.streamflow$data$year)

# timing LSAM
tlsam = getTimingLSAM(lsam$Index.all, x.sp$peak.index, x.sp$year)

}
