% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{eel}
\alias{eel}
\title{Eel data}
\format{
A tibble with 113 rows and 4 variables.
}
\source{
\href{https://www.discovr.rocks/csv/eel.csv}{www.discovr.rocks/csv/eel.csv}
}
\usage{
eel
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Lo, Wong, Leung, Law, and Yip (2004) describe a case of a 50-year-old man who reported to the emergency department of a hospital with abdominal pain.
An X-ray of the man's abdomen revealed the shadow of an eel. The patient claimed that he inserted the eel to 'relieve constipation'.
I'm no medic, but this 'remedy' appears counterintuitive. However, it is an empirical question.

To test the hypothesis that an eel might cure constipation, we could do a randomized controlled trial.
Our outcome variable would be 'cured' vs. 'not cured'. The main predictor variable would be the intervention condition
(eel treatment arm vs. waiting list/no treatment arm). We might also factor in how many days the patient had been
constipated before treatment (a proxy of symptom severity). The (fictional) data contains the following variables:
\itemize{
\item \strong{id}: Participant id
\item \strong{cured}: Whether the participant cured or not after treatment
\item \strong{intervention}: Whether the participant was randomized to the no intervention arm of the trial or the intervention arm
\item \strong{duration}: the number of days before treatment that the patient had the problem
}
}
\references{
\itemize{
\item Lo, S. F., Wong, S. H., Leung, L. S., Law, I. C., & Yip, A. W. C. (2004). Traumatic rectal perforation by an eel. Surgery, 135, 110–111. \doi{10.1016/S0039-6060(03)00076-X}
}
}
\keyword{datasets}
