% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{zombie_growth}
\alias{zombie_growth}
\title{Zombie growth model}
\format{
A tibble with 564 rows and 5 variables.
}
\source{
\href{https://www.discovr.rocks/csv/zombie_growth.csv}{www.discovr.rocks/csv/zombie_growth.csv}
}
\usage{
zombie_growth
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
In the story within Field (2016) a lot of people get turned into zombies. At the end of the book
it is revealed that one of the central characters, Alice, uses a gene therapy that she invented to restore the zombies back to a human state.
This dataset relates to her second study in which she tracked efficacy over 12 months after the treatment. The contains measures from
141 zombies measured at four timepoints (baseline and 1, 6, and 12 month follow-up). Zombies were randomly assigned to two arms of the trial (wait list vs. gene therapy) and the outcome was
how much they resembled their pre-zombie state (as a percentage).
\itemize{
\item \strong{id}: The zombie's id
\item \strong{intervention}: a factor that codes which arm of the trial the participant was randomized to (wait list or gene therapy).
\item \strong{time}: categorical variable indicating at which phase of the trial resemblance was measured (Baseline, 1 month, 6 months or 12 months).
\item \strong{resemblance}: How closely their face resembled their pre-zombified state (100\\% = the participants face is exactly like their original face, 0\\% the person bears no resemblance to their pre-zombified face).
\item \strong{time_num}: numerical variable indicating how many months since the intervention resemblance was measured.
}
}
\references{
\itemize{
\item Field, A. P. (2016). \emph{An adventure in statistics: the reality enigma}. London: Sage. \url{https://www.statisticsadventure.com}
}
}
\keyword{datasets}
