% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissever.R
\docType{methods}
\name{dissever}
\alias{dissever}
\alias{dissever,RasterLayer,RasterStack-method}
\alias{dissever,RasterLayer,RasterLayer-method}
\title{Spatial downscaling}
\usage{
\S4method{dissever}{RasterLayer,RasterLayer}(coarse, fine, method = "rf",
  p = 0.5, nmax = NULL, thresh = 0.01, min_iter = 5, max_iter = 20,
  boot = NULL, level = 0.9, tune_length = 3,
  tune_grid = .create_tune_grid(model = method, tune_length = tune_length),
  train_control_init = .default_control_init,
  train_control_iter = .default_control_iter, verbose = FALSE)
}
\arguments{
\item{coarse}{object of class \code{"RasterLayer"}, the coarse-resolution layer that needs to be downscaled}

\item{fine}{object of class \code{"RasterStack"}, the fine-resolution stack of predictive covariates}

\item{method}{a string specifying which classification or regression model to use (via the caret package). Possible values are found using names(caret::getModelInfo()).}

\item{p}{numeric, proportion of the fine map that is sampled for fitting the dissever model (between 0 and 1, defaults to 0.5)}

\item{nmax}{numeric maximum number of pixels selected for fitting the dissever model. It will override the number of pixels chosen by the \code{p} option if that number is over the value passed to \code{nmax}.}

\item{thresh}{numeric, dissever iterations will proceed until the RMSE of the dissever model reaches this value, or until the maximum number of iterations is met (defaults to 0.01)}

\item{min_iter}{numeric, minimum number of iterations (defaults to 5)}

\item{max_iter}{numeric, maximum number of iterations (defaults to 20)}

\item{boot}{numeric, if not NULL (default), the number of bootstrap replicates used to derive the confidence intervals.}

\item{level}{If this is a numeric value, it is used to derive confidence intervals using quantiles. If it is a function, it is used to derive the uncertainty using this function.}

\item{tune_length}{numeric, the number of parameters to test to find the optimal parametrisation of the caret model (defaults to 3)}

\item{tune_grid}{a data frame with possible tuning values}

\item{train_control_init}{Control parameters for finding the optimal parameters of the caret model (see trainControl)}

\item{train_control_iter}{Control parameters for fitting the caret model during the iteration phase (see trainControl)}

\item{verbose}{controls the verbosity of the output (TRUE or FALSE)}
}
\description{
Performs spatial downscaling of coarse grid mapping to fine grid mapping using predictive covariates and a model fitted using the caret package.
}
\examples{
# Load the Edgeroi dataset (see ?edgeroi)
data(edgeroi)

# Plot the Edgeroi dataset (using the raster package)
library(raster)
plot(edgeroi$carbon) # coarse resolution layer
plot(edgeroi$predictors) # fine resolution predictors

# Run dissever using a simple linear model.

# In this instance we are subsampling heavily (p = 0.05) to keep
# run time short
res_lm <- dissever(
  coarse = edgeroi$carbon,
  fine = edgeroi$predictors,
  method = "lm",
  min_iter = 5, max_iter = 10,
  p = 0.05
)

# A lot more models are available through caret:
\dontrun{
subset(caret::modelLookup(), forReg == TRUE, select = 'model')
}

# Plot dissever results
plot(res_lm, type = 'map', main = "Dissever using GAM")
plot(res_lm, type = 'perf', main = "Dissever using GAM")

}
\references{
Malone, B.P, McBratney, A.B., Minasny, B., Wheeler, I., (2011) A general method for downscaling earth resource information. Computers & Geosciences, 41: 119-125. \url{http://dx.doi.org/10.1016/j.cageo.2011.08.021}
}
\author{
Brendan Malone, Pierre Roudier
}
