% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distcomp-package.R
\name{saveNewNCP}
\alias{saveNewNCP}
\title{Save an NCP instance, given the sites as associated data and
possibly a data file name to use}
\usage{
saveNewNCP(defn, comp_defn, data, dataFileName = NULL)
}
\arguments{
\item{defn}{a definition of the ncp}

\item{comp_defn}{the computation definition}

\item{data}{the list of sites with name and url to use}

\item{dataFileName}{a file name to use for saving the
data. Typically \code{NULL}, this is only needed when one is using a
single opencpu server to behave like multiple sites in which
case the data file name serves to distinguish the site-specific
data files.  When it is \code{NULL}, the data file name is taken
from the definition settings}
}
\value{
TRUE if everything goes well
}
\description{
The function \code{saveNewNCP} uses the list of sites
definition to save a new NCP instance. This is
typically done for every pair of NCPs used in a computation. The function examines the
computation definition and uses the identifier therein to
uniquely refer to the computation instance at the site.  This
function is invoked (maybe remotely) on the opencpu server by
\code{\link[=uploadNewComputation]{uploadNewComputation()}} when a worker site is being set up
}
\seealso{
\code{\link[=uploadNewNCP]{uploadNewNCP()}}
}
