# Intended for package testing only.
test_dfr_functions <- function(object, digits = 3, newdata){
  signif_or_null <- function(x, ...) tryCatch(signif(x, ...), error = function(e) NULL)
  print(signif_or_null(coef(object), digits = digits))
  print(signif_or_null(confint(object), digits = digits))
  print(signif_or_null(fitted(object), digits = digits))
  form <- formula(object)
  print(signif_or_null(predict(object), digits = digits))
  print(signif_or_null(predict(object, newdata = newdata), digits = digits))
  print(signif_or_null(vcov(object), digits = digits))
}
