% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{publish_website}
\alias{publish_website}
\title{Publish a Distill Website}
\usage{
publish_website(
  site_dir = ".",
  site_name = NULL,
  method = c("rsconnect"),
  server = NULL,
  account = NULL,
  render = TRUE,
  launch_browser = interactive()
)
}
\arguments{
\item{site_dir}{Directory containing website. Defaults to current working directory.}

\item{site_name}{Name for the site (names must be unique within an account). Defaults
to the \code{name} provided in \verb{_site.yml} (or to the name of the site_dir if there is no
\code{name} specified).}

\item{method}{Publishing method (currently only "rsconnect" is available)}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[rsconnect:accounts]{accounts()}} to see the full list of available options.}

\item{render}{\code{TRUE} to render the site locally before publishing.}

\item{launch_browser}{If \code{TRUE}, the system's default web browser will be launched
automatically after the site is deployed. Defaults to \code{TRUE} in interactive sessions
only.}
}
\description{
Publish a website to RStudio Connect
}
\examples{
\dontrun{
library(distill)
publish_website()
}

}
