% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonBinomial.R
\name{quantile.PoissonBinomial}
\alias{quantile.PoissonBinomial}
\title{Determine quantiles of a PoissonBinomial distribution}
\usage{
\method{quantile}{PoissonBinomial}(
  x,
  probs,
  drop = TRUE,
  elementwise = NULL,
  lower.tail = TRUE,
  log.p = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{PoissonBinomial} object created by a call to \code{\link[=PoissonBinomial]{PoissonBinomial()}}.}

\item{probs}{A vector of probabilities.}

\item{drop}{logical. Shoul the result be simplified to a vector if possible?}

\item{elementwise}{logical. Should each distribution in \code{x} be evaluated
at all elements of \code{probs} (\code{elementwise = FALSE}, yielding a matrix)?
Or, if \code{x} and \code{probs} have the same length, should the evaluation be
done element by element (\code{elementwise = TRUE}, yielding a vector)? The
default of \code{NULL} means that \code{elementwise = TRUE} is used if the
lengths match and otherwise \code{elementwise = FALSE} is used.}

\item{lower.tail, log.p, ...}{Arguments to be passed to
\code{\link[PoissonBinomial]{qpbinom}} or \code{\link[stats]{qnorm}}, respectively.}

\item{verbose}{logical. Should a warning be issued if the normal approximation
is applied because the \pkg{PoissonBinomial} package is not installed?}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(probs)} columns (if \code{drop = FALSE}). In case of a vectorized
distribution object, a matrix with \code{length(probs)} columns containing all
possible combinations.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- PoissonBinomial(0.5, 0.3, 0.8)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 2)
quantile(X, 0.8)

cdf(X, quantile(X, 0.8))
quantile(X, cdf(X, 2))

## equivalent definitions of four Poisson binomial distributions
## each summing up three Bernoulli probabilities
p <- cbind(
  p1 = c(0.1, 0.2, 0.1, 0.2),
  p2 = c(0.5, 0.5, 0.5, 0.5),
  p3 = c(0.8, 0.7, 0.9, 0.8))
PoissonBinomial(p)
PoissonBinomial(p[, 1], p[, 2], p[, 3])
PoissonBinomial(p[, 1:2], p[, 3])
}
