% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combdist.R
\name{combdist.mle}
\alias{combdist.mle}
\title{Combined distributions MLE}
\usage{
combdist.mle(
  x,
  dist,
  start = NULL,
  lower = NULL,
  upper = NULL,
  components = 1,
  nested = FALSE,
  steps = 1,
  lowertrunc = 0,
  uppertrunc = Inf,
  ...
)
}
\arguments{
\item{x}{data vector}

\item{dist}{character vector denoting the distribution(s).}

\item{start}{named numeric vector holding the starting values for the coefficients.}

\item{lower, upper}{Lower and upper bounds to the estimated coefficients, defaults to -Inf and Inf respectively.}

\item{components}{number of components for a mixture distribution.}

\item{nested}{logical indicating whether results should be returned in a nested list or a flat list  form, defaults to FALSE.}

\item{steps}{number of steps taken in stepflexmix, defaults to 1.}

\item{lowertrunc, uppertrunc}{lowertrunc- and uppertrunc truncation points, defaults to 0 and Inf respectively}

\item{...}{Additional arguments.}
}
\value{
Returns a named list containing a
\describe{
\item{dist}{Character vector denoting the distributions, separated by an underscore}
\item{components}{Nr. of combined distributions}
\item{prior}{Weights assigned to the respective component distributions}
\item{coefficients}{Named vector of coefficients}
\item{convergence}{logical indicator of convergence}
\item{n}{Length of the fitted data vector}
\item{np}{Nr. of coefficients}
}
}
\description{
Maximum Likelihood estimation for combined ( single, composite and finite mixture) truncated or complete distributions.
}
\examples{

\donttest{
x <- rdoubleparetolognormal(1e3)
combdist.mle(x = x, dist = "doubleparetolognormal") # Double-Pareto Lognormal
combdist.mle(x = x, components = 2, dist = "lnorm", steps = 20) # FMM with 2 components
combdist.mle( x = x, dist = c("invpareto", "lnorm", "pareto"),
start = c(coeff1.k = 1, coeff2.meanlog = mean(log(x)), coeff2.sdlog = sd(log(x)), coeff3.k = 1),
lower = c(1e-10, -Inf, 1e-10, 1e-10), upper = c(Inf, Inf, Inf, Inf), nested = TRUE)
# composite distribution
}

}
