% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechet.R
\name{frechet.mle}
\alias{frechet.mle}
\title{Fréchet MLE}
\usage{
frechet.mle(
  x,
  weights = NULL,
  start = c(shape = 1.5, scale = 0.5),
  lower = c(1e-10, 1e-10),
  upper = c(Inf, Inf)
)
}
\arguments{
\item{x}{data vector}

\item{weights}{numeric vector for weighted MLE, should have the same length as data vector x}

\item{start}{named vector with starting values, default to c(shape=1.5,scale=0.5)}

\item{lower, upper}{Lower and upper bounds to the estimated shape parameter, defaults to 1e-10 and Inf respectively}
}
\value{
Returns a named list containing a
\describe{
\item{coefficients}{Named vector of coefficients}
\item{convergence}{logical indicator of convergence}
\item{n}{Length of the fitted data vector}
\item{np}{Nr. of coefficients}
}

x = rfrechet(1e3)

## Pareto fit with xmin set to the minium of the sample
frechet.mle(x=x)
}
\description{
Maximum likelihood estimation of the coefficients of the Fréchet distribution
}
