% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechet.R
\name{frechet_plt}
\alias{frechet_plt}
\title{Fréchet coefficients after power-law transformation}
\usage{
frechet_plt(shape = 1.5, scale = 0.5, a = 1, b = 1, inv = FALSE)
}
\arguments{
\item{shape, scale}{Scale and shape of the Fréchet distribution, defaults to 1.5 and 0.5 respectively.}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}
}
\value{
Returns a named list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}

 ## Comparing probabilites of power-law transformed transformed variables
 pfrechet(3,shape=2,scale=1)
 coeff = frechet_plt(shape=2,scale=1,a=5,b=7)$coefficients
 pfrechet(5*3^7,shape=coeff[["shape"]],scale=coeff[["scale"]])

 pfrechet(5*0.8^7,shape=2,scale=1)
 coeff = frechet_plt(shape=2,scale=1,a=5,b=7,inv=TRUE)$coefficients
 pfrechet(0.8,shape=coeff[["shape"]],scale=coeff[["scale"]])
}
\description{
Coefficients of a power-law transformed Fréchet distribution
}
\details{
If the random variable x is Fréchet distributed with scale shape and shape scale, then the power-law transformed variable

 \deqn{ y = ax^b }

 is Fréchet distributed with scale \eqn{ \left( \frac{scale}{a}\right)^{\frac{1}{b}} } and shape \eqn{b*k}.
}
