% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefttparetolognormal.R
\name{leftparetolognormal.mle}
\alias{leftparetolognormal.mle}
\title{Left-Pareto Lognormal MLE}
\usage{
leftparetolognormal.mle(
  x,
  lower = c(1e-10, 1e-10),
  upper = c(Inf, Inf),
  start = NULL
)
}
\arguments{
\item{x}{data vector}

\item{lower, upper}{Upper and lower bounds for the estimation procedure on the parameters c(shape1,sdlog), defaults to c(1e-10,1e-10) and c(Inf,Inf) respectively.}

\item{start}{named vector with starting values, default to c(shape1=2,sdlog=sd(log(x)))}
}
\value{
Returns a named list containing a
\describe{
\item{coefficients}{Named vector of coefficients}
\item{convergence}{logical indicator of convergence}
\item{n}{Length of the fitted data vector}
\item{np}{Nr. of coefficients}
}

x = rleftparetolognormal(1e3)

## Pareto fit with xmin set to the minium of the sample
leftparetolognormal.mle(x=x)
}
\description{
Maximum likelihood estimation of the parameters of the Left-Pareto Lognormal distribution.
}
