% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto.R
\name{pareto_plt}
\alias{pareto_plt}
\title{Pareto coefficients after power-law transformation}
\usage{
pareto_plt(xmin = 1, k = 2, a = 1, b = 1, inv = FALSE)
}
\arguments{
\item{xmin, k}{Scale and shape of the Pareto distribution, defaults to 1 and 2 respectively.}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}
}
\value{
Returns a named list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}
}
\description{
Coefficients of a power-law transformed Pareto distribution
}
\details{
If the random variable x is Pareto-distributed with scale xmin and shape k, then the power-law transformed variable

 \deqn{ y = ax^b }

 is Pareto distributed with scale \eqn{ ( \frac{xmin}{a})^{\frac{1}{b}} } and shape \eqn{b*k}.
}
\examples{

## Comparing probabilites of power-law transformed transformed variables
ppareto(3, k = 2, xmin = 2)
coeff <- pareto_plt(xmin = 2, k = 2, a = 5, b = 7)$coefficients
ppareto(5 * 3^7, k = coeff[["k"]], xmin = coeff[["xmin"]])

ppareto(5 * 0.9^7, k = 2, xmin = 2)
coeff <- pareto_plt(xmin = 2, k = 2, a = 5, b = 7, inv = TRUE)$coefficients
ppareto(0.9, k = coeff[["k"]], xmin = coeff[["xmin"]])

## Comparing the first moments and sample means of power-law transformed variables for
#large enough samples
x <- rpareto(1e5, k = 2, xmin = 2)
coeff <- pareto_plt(xmin = 2, k = 2, a = 2, b = 0.5)$coefficients
y <- rpareto(1e5, k = coeff[["k"]], xmin = coeff[["xmin"]])
mean(2 * x^0.5)
mean(y)
mpareto(r = 1, k = coeff[["k"]], xmin = coeff[["xmin"]], lower.tail = FALSE)
}
