% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncdist.R
\name{truncdist}
\alias{truncdist}
\alias{dtruncdist}
\alias{ptruncdist}
\alias{qtruncdist}
\alias{mtruncdist}
\alias{rtruncdist}
\title{Truncated distribution}
\usage{
dtruncdist(
  x,
  dist = c("lnormtrunc"),
  coeff = list(meanlog = 0, sdlog = 1),
  lowertrunc = 0,
  uppertrunc = Inf,
  log = FALSE
)

ptruncdist(
  q,
  dist = c("lnormtrunc"),
  coeff = list(meanlog = 0, sdlog = 1),
  lowertrunc = 0,
  uppertrunc = Inf,
  log.p = FALSE,
  lower.tail = TRUE
)

qtruncdist(
  p,
  dist = c("lnormtrunc"),
  coeff = list(meanlog = 0, sdlog = 1),
  lowertrunc = 0,
  uppertrunc = Inf,
  lower.tail = TRUE,
  log.p = FALSE
)

mtruncdist(
  r,
  truncation = 0,
  dist = c("lnormtrunc"),
  coeff = list(meanlog = 0, sdlog = 1),
  lowertrunc = 0,
  uppertrunc = Inf,
  lower.tail = TRUE
)

rtruncdist(
  n,
  dist = c("lnormtrunc"),
  coeff = list(meanlog = 0, sdlog = 1),
  lowertrunc = 0,
  uppertrunc = Inf
)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{dist}{distribution to be truncated, defaults to lnorm}

\item{coeff}{list of parameters for the truncated distribution, defaults to list(meanlog=0,sdlog=1)}

\item{lowertrunc, uppertrunc}{lowertrunc- and uppertrunc truncation points, defaults to 0 and Inf respectively}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities (moments) are \eqn{P[X \le x]} \eqn{(E[x^r|X \le y])}, otherwise, \eqn{P[X > x]} \eqn{(E[x^r|X > y])}}

\item{p}{vector of probabilities}

\item{r}{rth raw moment of the distribution}

\item{truncation}{lowertrunc truncation parameter, defaults to 0.}

\item{n}{number of observations}
}
\value{
dtruncdist gives the density, ptruncdist gives the distribution function, qtruncdist gives the quantile function, mtruncdist gives the rth moment of the distribution and rtruncdist generates random deviates.

 The length of the result is determined by n for rpareto, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function, raw moments and random generation for a truncated distribution.
}
\details{
Probability and Cumulative Distribution Function:

 \deqn{f(x) = \frac{g(x)}{F(uppertrunc)-F(lowertrunc)}, \qquad F_X(x) = \frac{F(x)-F(lowertrunc)}{F(uppertrunc)-F(lowertrunc)}}
}
\examples{

## Truncated lognormal density
plot(x = seq(0.5, 3, length.out = 100), y = dtruncdist(x = seq(0.5, 5, length.out = 100),
dist = "lnorm", coeff = list(meanlog = 0.5, sdlog = 0.5), lowertrunc = 0.5, uppertrunc = 5))
lines(x = seq(0, 6, length.out = 100), y = dlnorm(x = seq(0, 6, length.out = 100),
meanlog = 0.5, sdlog = 0.5))

# Compare quantities
dtruncdist(0.5)
dlnorm(0.5)
dtruncdist(0.5, lowertrunc = 0.5, uppertrunc = 3)

ptruncdist(2)
plnorm(2)
ptruncdist(2, lowertrunc = 0.5, uppertrunc = 3)

qtruncdist(0.25)
qlnorm(0.25)
qtruncdist(0.25, lowertrunc = 0.5, uppertrunc = 3)

mtruncdist(r = 0, truncation = 2)
mlnorm(r = 0, truncation = 2, meanlog = 0, sdlog = 1)
mtruncdist(r = 0, truncation = 2, lowertrunc = 0.5, uppertrunc = 3)

mtruncdist(r = 1, truncation = 2)
mlnorm(r = 1, truncation = 2, meanlog = 0, sdlog = 1)
mtruncdist(r = 1, truncation = 2, lowertrunc = 0.5, uppertrunc = 3)
}
