% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcc_new.R, R/dcc6_fixed.R
\name{dcc6}
\alias{dcc6}
\alias{dcc6_fixed}
\title{Data cube creation}
\usage{
dcc6(
  .data,
  .variables,
  .funs_list = list(n = ~dplyr::n()),
  .total = "Totale",
  order_type = extract_unique4,
  .all = TRUE
)

dcc6_fixed(
  .data,
  .variables,
  .funs_list = list(n = ~dplyr::n()),
  .total = "Totale",
  order_type = extract_unique5,
  .all = TRUE,
  fixed_variable = NULL
)
}
\arguments{
\item{.data}{data frame to be processed.}

\item{.variables}{variables to split data frame by, as a character vector 
(\code{c("var1", "var2")}).}

\item{.funs_list}{a list of function calls in the form of right-hand formula.}

\item{.total}{character string with the name to give to the subset of data
that includes all the observations of a variable (default: \code{"Totale"}).}

\item{order_type}{a function like \code{\link{extract_unique}} or 
\code{\link{extract_unique2}}.}

\item{.all}{logical, indicating if functions have to be evaluated on the 
complete dataset.}

\item{fixed_variable}{name of the variable for which you do not want to estimate the total}
}
\description{
Data cube creation
}
\examples{
dcc6(invented_wages,
     .variables = c("gender", "sector"), 
     .funs_list = list(n = ~dplyr::n()),
     .all = TRUE)
     
dcc6(invented_wages,
     .variables = c("gender", "sector"), 
     .funs_list = list(n = ~dplyr::n()),
     .all = FALSE)

}
