% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spat_prox.R
\name{ds_spat_prox}
\alias{ds_spat_prox}
\alias{spat_prox}
\title{Compute Spatial Proximity}
\usage{
ds_spat_prox(.data, .cols, .name)

spat_prox(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble} with sf geometry}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with spatial proximity. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_spat_prox from spat_prox}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Spatial Proximity
}
\examples{
data('de_county')
ds_spat_prox(de_county, c(pop_black, starts_with('pop_')))
ds_spat_prox(de_county, c(pop_black, starts_with('pop_')), 'spat_prox')
}
\concept{clustering}
