% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlanalysis.R
\name{dlanalysis}
\alias{dlanalysis}
\title{dlanalysis}
\usage{
dlanalysis(dlresult, alpha = 0.05)
}
\arguments{
\item{dlresult}{Posterior samples of beta. A large matrix (nmc/thin)*p}

\item{alpha}{Level for the credible intervals. For example,the default is alpha = 0.05 means 95\% credible intervals}
}
\value{
\item{betamean}{Posterior mean of beta, a p*1 vector.}
           \item{LeftCI}{The left bounds of the credible intervals.}
           \item{RightCI}{The right bounds of the credible intervals.}
           \item{betamedian}{Posterior median of Beta, a p*1 vector.}
}
\description{
This is a function that analyse the MCMC sampling result by computing the posterior mean,
median and credible intervals
}
\examples{
p=50
n=5
#generate x
x=matrix(rnorm(n*p),nrow=n)
#generate beta
beta=c(rep(0,10),runif(n=5,min=-1,max=1),rep(0,10),runif(n=5,min=-1,max=1),rep(0,p-30))
#generate y
y=x\%*\%beta+rnorm(n)
hyper=dlhyper(x,y)
dlresult=dl(x,y,hyper=hyper)
da=dlanalysis(dlresult,alpha=0.05)
da$betamean
da$betamedian
da$LeftCI
da$RightCI


}
