% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{set_app_cache_dir}
\alias{set_app_cache_dir}
\title{Set a Cache Directory for an App}
\usage{
set_app_cache_dir(appname, cache_dir = NULL)
}
\arguments{
\item{appname}{Character; the name of the application that will "own" the
cache, such as the name of a package.}

\item{cache_dir}{Character scalar; a path to a cache directory.}
}
\value{
A normalized path to a cache directory. The directory is created if
the user has write access and the directory does not exist. An option is
also set so future calls to \code{\link{app_cache_dir}} will respect the
change.
}
\description{
Override the default paths used by \code{\link{app_cache_dir}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Executing this function creates a cache directory.
set_app_cache_dir(appname = "dlr", cache_dir = "/my/cache/path")
\dontshow{\}) # examplesIf}
}
