% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{splitt}
\alias{splitt}
\alias{dsplitt}
\alias{psplitt}
\alias{qsplitt}
\alias{rsplitt}
\title{Split-t distribution}
\usage{
dsplitt(x, mu, df, phi, lmd, logarithm)

psplitt(q, mu, df, phi, lmd)

qsplitt(p, mu, df, phi, lmd)

rsplitt(n, mu, df, phi, lmd)
}
\arguments{
\item{x}{vector of quantiles.}

\item{mu}{vector of location parameter. (The mode of the density)}

\item{df}{degrees of freedom (> 0, can be non-integer). df = Inf is also allowed.}

\item{phi}{vector of scale parameters (>0).}

\item{lmd}{vector of skewness parameters (>0). If is 1, reduced to the
symmetric student t distribution.}

\item{logarithm}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{p}{vector of probability.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
\code{dsplitt} gives the density; \code{psplitt} gives the percentile;
\code{qsplitt} gives the quantile; and \code{rsplitt} gives the random
variables. Invalid arguments will result in return value NaN, with a warning.

The numerical arguments other than n are recycled to the length of the
result. Only the first elements of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation for the normal
distribution for the split student-t distribution.
}
\details{
The random variable y follows a split-t distribution with \eqn{\nu}>0
degrees of freedom, y~t(\eqn{\mu}, \eqn{\phi}, \eqn{\lambda}, \eqn{\nu}),
if its density function is of the form

\deqn{C K(\mu, \phi, \nu,)I(y\leq\mu) + C K(\mu, \lambda \phi,
\nu)I(y>\mu), } where, \deqn{K(\mu, \phi, \nu,) =[\nu/(\nu+(y-\mu)^2 /\phi
^2)]^{(\nu+1)/2} } is the kernel of a student \eqn{t} density with variance
\eqn{\phi ^2\nu/(\nu-2)} and \deqn{c = 2[(1+\lambda)\phi (\sqrt \nu)
Beta(\nu/2,1/2)]^{-1} }is the normalization constant.
}
\section{Functions}{
\itemize{
\item \code{psplitt}: Percentile for the split-t distribution.

\item \code{qsplitt}: Quantile for the split-t distribution.

\item \code{rsplitt}: Randon variables from the split-t distribution.
}}

\examples{

n <- 3
mu <- c(0,1,2)
df <- rep(10,3)
phi <- c(0.5,1,2)
lmd <- c(1,2,3)

q0 <- rsplitt(n, mu, df, phi, lmd)
d0 <- dsplitt(q0, mu, df, phi, lmd, logarithm = FALSE)
p0 <- psplitt(q0, mu, df, phi, lmd)
q1 <- qsplitt(p0,mu, df, phi, lmd)
all.equal(q0, q1)

}
\references{
Li, F., Villani, M., & Kohn, R. (2010). Flexible modeling of
conditional distributions using smooth mixtures of asymmetric student t
densities. Journal of Statistical Planning & Inference, 140(12), 3638-3654.
}
\seealso{
\code{\link{splitt_mean}()},
\code{\link{splitt_var}()},\code{\link{splitt_skewness}()} and
\code{\link{splitt_kurtosis}()} for numerical characteristics of the
Split-t distribution.
}
\author{
Feng Li, Jiayue Zeng
}
\keyword{asymmetric}
\keyword{distribution}
\keyword{student-t}
