% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docstring.R
\name{docstring}
\alias{docstring}
\alias{?}
\title{Display a docstring}
\usage{
docstring(fun, fun_name = as.character(substitute(fun)),
  rstudio_pane = getOption("docstring_rstudio_help_pane"),
  default_title = "Title not detected")
}
\arguments{
\item{fun}{The function that has the docstring you would like to display}

\item{fun_name}{The name of the function.}

\item{rstudio_pane}{logical. If running in RStudio do you want the help
to show in the help pane? This defaults to TRUE but can be explicitly set
using options("docstring_rstudio_help_pane" = TRUE) or
options("docstring_rstudio_help_pane" = FALSE)}

\item{default_title}{The title you would like to display if no title is detected
in the docstring itself.}
}
\description{
Display a docstring using R's built in help file viewer.
}
\examples{
\dontrun{
square <- function(x){
  #' Square a number
  #'
  #' Calculates the square of the input
  #' 
  #' @param x the input to be squared

  return(x^2)
}

docstring(square)
?square


mypaste <- function(x, y = "!"){
  #' Paste two items
  #' 
  #' @description This function pastes two items
  #' together.  
  #'
  #' By using the description tag you'll notice that I
  #' can have multiple paragraphs in the description section
  #' 
  #' @param x character. The first item to paste
  #' @param y character. The second item to paste Defaults to "!" but
  #' "?" would be pretty great too
  #' @usage mypaste(x, y)
  #' @return The inputs pasted together as a character string.
  #' @details The inputs can be anything that can be input into
  #' the paste function.
  #' @note And here is a note. Isn't it nice?
  #' @section I Must Warn You:
  #' The reference provided is a good read.
  #' \\subsection{Other warning}{
  #'   It is completely irrelevant to this function though.
  #' }
  #' 
  #' @references Tufte, E. R. (2001). The visual display of 
  #' quantitative information. Cheshire, Conn: Graphics Press.
  #' @examples
  #' mypaste(1, 3)
  #' mypaste("hey", "you")
  #' mypaste("single param")
  #' @export
  #' @importFrom base paste
  
  return(paste(x, y))
}
  
?mypaste
}

}
