% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doremi.R
\name{generate.panel.1order}
\alias{generate.panel.1order}
\title{Generation of first order differential equation solutions for several individuals with intra-individual
and inter-individual noise}
\usage{
generate.panel.1order(
  time,
  excitation = NULL,
  y0 = 0,
  t0 = NULL,
  tau = 10,
  k = 1,
  yeq = 0,
  nind = 1,
  internoise = 0,
  intranoise = 0
)
}
\arguments{
\item{time}{Is a vector containing the time values corresponding to the excitation signal.}

\item{excitation}{Is a vector containing the values of the excitation signal (u(t) in the equation). If NULL, it is considered to be 0.}

\item{y0}{Signal initial value y(t=t0). Default is 0}

\item{t0}{Time corresponding to the signal initial value y(t=t0). Default is the minimum value of the time vector.
Must be a value between minimum and maximum value of the time vector}

\item{tau}{Signal decay time. It represents the characteristic response time of the solution of the differential equation.
A negative value will produce divergence from equilibrium.}

\item{k}{Signal gain. Default is 1. It represents the proportionality between the stationary increase of signal and the excitation increase that caused it.
Only relevant if the excitation is non null.}

\item{yeq}{Signal equilibrium value. Stationary value when the excitation term is 0.}

\item{nind}{number of individuals.}

\item{internoise}{Is the inter-individual noise added. The tau across individuals follows a normal distribution centered on the input parameter tau
with a standard deviation of internoise*tau, except if any decay time is negative (see Details section). The same applies to the other coefficients of the differential
equation (k and yeq)}

\item{intranoise}{Is the noise to signal  ratio: dynamic noise added to each signal defined as the ratio between the variance  of the noise and the variance of the signal}
}
\value{
Returns a data frame containing the following columns:
\itemize{
   \item id - individual identifier (from 1 to nind).
   \item excitation - excitation signal
   \item time - time values
   \item signalraw - signal with no noise (internoise provided added for each individual)
   \item dampedsignal - signal with intranoise added
}
}
\description{
\code{generate.panel.1order} Generation of first order differential equation solutions for several individuals with intra-individual and inter-individual noise.
For a panel of nind individual, the function generates
nind solutions of a first order differential equation with constant coefficients distributed along a normal distribution.
Measurement noise is added to each individual signal according to the value of the intranoise parameter.
}
\details{
Used for simulations in the context of the package.
The function currently simulates only positive decay times corresponding to a regulated system. When the decay time is low
and the inter individual noise is high, some individuals' decay time could be negative. In that case, the decay time
distribution is truncated at 0.1*deltat and values below are set to this limit. High values are symmetrically set at the upper percentile value
similar to a Winsorized mean. A warning provides the initial inter individual noise set as input argument and the inter individual
noise obtained after truncation.
}
\examples{
generate.panel.1order(time = generate.excitation(3, 6, 2, 1, 200, 2)$t,
                      excitation = generate.excitation(3, 6, 2, 1, 200, 2)$exc,
                      y0 = 0,
                      tau = 10,
                      k = 1,
                      yeq = 0,
                      nind = 5,
                      internoise = 0.2,
                      intranoise = 1)
}
\seealso{
\code{\link{generate.1order}} for calculation of the numerical solution to the differential equation
and \code{\link{generate.excitation}} for excitation signal generation
}
\keyword{differential-equation}
\keyword{first-order}
\keyword{simulation}
