% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_helpers.R
\name{sharp_double_statistic}
\alias{sharp_double_statistic}
\title{Statistic based on inner product between transformations of dose and outcome.}
\usage{
sharp_double_statistic(z, r, q1, q2)
}
\arguments{
\item{z}{a vector of doses}

\item{r}{a vector of outcomes}

\item{q1}{a function that transforms the doses z}

\item{q2}{a function that transforms the outcomes r}
}
\value{
a vector with values corresponding to the inner product of transformed
by q1 permutations of z with transformed by q2 versions of r.
}
\description{
Statistic based on inner product between transformations of dose and outcome.
}
\examples{
# dose vector
dose <- c(0, 0.1, 0.4)
# outcome vector
outcome <- c(1, 1.1, 1.5)
# transforms
transform1 <- function(x) x
transform2 <- function (x) x
theta <- sharp_double_statistic(z = dose, r = outcome, q1 = transform1,
q2 = transform2)
}
