% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1Dthresholds.R
\name{find_thr_by_params}
\alias{find_thr_by_params}
\title{Thresholds estimations for 1D from GMM parameters}
\usage{
find_thr_by_params(alpha, mu, sigma, input, sigmas.dev = 2.5)
}
\arguments{
\item{alpha}{Vector containing the weights (alpha) for each component in the statistical model.}

\item{mu}{Vector containing the means (mu) for each component in the statistical model.}

\item{sigma}{Vector containing the standard deviation (sigma) for each component in the statistical model.}

\item{input}{output of \code{\link{generate_dist}} function. Its necessary only if arithmetical approach fails in threshold estimation and \code{\link{find_thr_by_dist}} function is called.
It is a list with following elements:\describe{
   \item{x}{Numeric vector with equaliy spread data of given precison.}
   \item{dist}{Matrix with PDF of each GMM component and cumulative distribution.}
}}

\item{sigmas.dev}{Number of sigmas to secure thresholds on the ends of distributions. Equivalent to sigma.dev in merging GMMs.}
}
\value{
Return a vector of thresholds.
}
\description{
Function to calculate cutoffs between each component of mixture normal distributions based on the component parameters.
}
\examples{
data(example)

alpha <- c(0.45, 0.5, 0.05)
mu <- c(-14, -2, 5)
sigma <- c(2, 4, 1.5)

dist.plot <- generate_dist(example$Dist, alpha = alpha, mu = mu, sigma = sigma, 1e4)
thr <- find_thr_by_params(alpha = alpha, mu = mu, sigma = sigma, dist.plot)

}
\seealso{
\code{\link{runGMM}}
}
