% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm_merge.R
\name{gmm_merge}
\alias{gmm_merge}
\title{Merging of overlapping components}
\usage{
gmm_merge(alpha, mu, sigma, sigmas.dev = 2.5)
}
\arguments{
\item{alpha}{Vector of alphas (weights) for each distribution.}

\item{mu}{Vector of means for each distribution.}

\item{sigma}{Vector of  sigmas for each distribution.}

\item{sigmas.dev}{Parameter used to define close GMM components that needs to be merged. For each component, standard deviation is multiplied by \code{sigmas.dev} to estimate the distance from component mean.
All other components within this distance are merged. By default it is \code{sigmas.dev = 2.5}. When \code{sigmas.dev = 0} no components are merged.}
}
\value{
Function returns a \code{list} which contains: \describe{
  \item{model}{\code{data.frame} of the GMM decomposition parameters after merging.}
  \item{KS}{number of components after merging.}
}
}
\description{
Function merges distributions of overlapping components at distances defined in the argument \code{sigmas.dev}.
}
\seealso{
\code{\link{runGMM}}
}
\keyword{internal}
