% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stats.R
\name{ms_stat}
\alias{ms_stat}
\title{Max-sum (MS) test statistic to identify dragon kings (DKs)}
\usage{
ms_stat(vals, r)
}
\arguments{
\item{vals}{numeric vector with at least 3 elements}

\item{r}{integer indicating number of DKs in \code{vals}}
}
\value{
MS test statistic
}
\description{
\code{ms_stat} calculates the MS test statistic to determine whether
there is significant support for the existence of \code{r} DKs in
\code{vals}. This statistic is less susceptible to swamping, but is also
less powerful in the case of clustered outliers, in comparison to the SS
and SRS test statistics.
}
\examples{
# generate a numeric vector with DKs
temp <- c(rexp(100),   # exponentially distributed RV
          15, 15, 15)  # DK elements

# calculate test statistic for DKs
ms_stat(temp, r = 3)
}
\references{
Wheatley S, Sornette D (2015). Multiple outlier detection in samples with exponential & pareto tails: Redeeming the inward approach & detecting dragon kings. Swiss Finance Institute Research Paper Series No. 15-28. <doi:10.2139/ssrn.2645709>

Hawkins DM (1980). Identification of outliers, vol. 11. \emph{Chapman and Hall}. ISBN: 9789401539944

Kimber AC (1982). Tests for many outliers in an exponential sample. \emph{Appl Statist}, \strong{31}(3): 263-71. <doi:10.2307/2348000>
}
