% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{basis_poly}
\alias{basis_poly}
\title{Estimate the score function of the d'th covariate using a polynomial basis.}
\usage{
basis_poly(X, d, degree = 2, lambda = NULL)
}
\arguments{
\item{X}{matrix of covariates.}

\item{d}{integer index of covariate of interest.}

\item{degree}{maximum degree of polynomial terms.}

\item{lambda}{optional scalar penalty, if "NULL" chosen via cross-validation.}
}
\value{
list containing the estimated score function "rho", which takes
matrix input and yields a vector of score estimates.
}
\description{
Computes the score function estimate when rho(X) is assumed to lie within the span
of the polynomial basis of X.
}
\examples{
set.seed(0)
X <- matrix(stats::rnorm(200), ncol=4)
bs <- basis_poly(X=X, d=1, degree=2)
bs$rho(X)
}
