% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATETrueValue.R
\name{ATETrueValue}
\alias{ATETrueValue}
\title{Calculates the true ATE effect.}
\usage{
ATETrueValue(dgptype, vIdx, n, g, pi)
}
\arguments{
\item{dgptype}{A scalar. The value can be string 1, 2, or 3,
respectively corresponding to the three DGP schemes in the paper (See Jiang et al. (2022) for DGP details).}

\item{vIdx}{A 1xR vector. The authors set vIdx=[1 2 3 4] in Jiang et al. (2022). Every number declares the method of covariate-adaptive randomization.
1-SRS; 2-WEI; 3-BCD; 4-SBR.}

\item{n}{Sample size.}

\item{g}{Number of strata. The authors set g=4 in Jiang et al. (2022).}

\item{pi}{Targeted assignment probability across strata.}
}
\value{
A 1xR vector. Simulated true ATE effect.
}
\description{
ATETrueValue is the version of TrueValue under full compliance.
}
\examples{
\donttest{
 ATETrueValue(dgptype = 1, vIdx = c(1,2,3,4), n = 100, g = 4, pi = c(0.5,0.5,0.5,0.5))
 ATETrueValue(dgptype = 2, vIdx = c(1,2,3,4), n = 100, g = 4, pi = c(0.5,0.5,0.5,0.5))
 ATETrueValue(dgptype = 3, vIdx = c(1,2,3,4), n = 100, g = 4, pi = c(0.5,0.5,0.5,0.5))
 }
}
\references{
Jiang L, Linton O B, Tang H, Zhang Y. Improving estimation efficiency via regression-adjustment in covariate-adaptive randomizations with imperfect compliance [J]. 2022.
}
