% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twomode_Constraint_deprecatedV100.R
\name{computeBCConstraint}
\alias{computeBCConstraint}
\title{Compute Burchard and Cornwell's (2018) Two-Mode Constraint}
\usage{
computeBCConstraint(net, isolates = NA, returnCIJmat = FALSE, weighted = FALSE)
}
\arguments{
\item{net}{A two-mode adjacency matrix or affiliation matrix.}

\item{isolates}{What value should isolates be given? Preset to be NA.}

\item{returnCIJmat}{TRUE/FALSE. TRUE indicates that the full constraint matrix, that is, the network constraint from an alter j on node i, will be returned to the user. FALSE indicates that the total constraint will be returned. Set to FALSE by default.}

\item{weighted}{TRUE/FALSE. TRUE indicates the resulting statistic will be based on the weighted formula (see the details section). FALSE indicates the statistic will be based on the original non-weighted formula. Set to FALSE by default.}
}
\value{
The vector of two-mode constraint scores for level 1 actors in a two-mode network.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{computeBCConstraint()} has been deprecated starting on version 1.0.0 of the \code{dream} package. Please use the \code{netstats_tm_constraint()} function and see the \code{NEWS.md} file for more details.

This function calculates the values for two-mode network constraint
for weighted and unweighted two-mode networks based on Burchard and Cornwell (2018).
}
\details{
Following Burchard and Cornwell (2018), the formula for two-mode constraint is:
\deqn{c_{ij} = \left(\frac{|\zeta(j) \cap \zeta(i)|}{|\zeta^{(i*)}|}\right)^2}
where:
\itemize{
\item \eqn{c_{ij}} is the constraint of ego \emph{i} with respect to actor \emph{j}.
\item \eqn{|\zeta(j) \cap \zeta(i)|} is the number of opposite-class contacts that \emph{i} and \emph{j} both share.
\item The denominator, \eqn{|\zeta^{(i*)}|}, represents the total number of opposite-class contacts of ego \emph{i} excluding pendants, that is, level 2 groups that only have one member.
}
The total constraint for ego \emph{i} is given by:
\deqn{C_{i} = \sum_{j \in \sigma(i)} c_{ij}}
The function returns the aggregate constraint for each actor; however, the user can specify the function to return the constraint matrix by setting \emph{returnCIJmat} to TRUE.

The function can also compute constraint for weighted two-mode networks by setting \emph{weighted} to TRUE. The formula for two-mode weighted constraint is:
\deqn{c_{ij} = \left(\frac{|\zeta(j) \cap \zeta(i)|}{|\zeta^{(i*)}|}\right)^2 \times w_{t}}
where \eqn{w_{t}} is the average of the tie weights that \emph{i} and \emph{j} send to their shared opposite-class contacts.
}
\examples{

# For this example, we recreate Figure 2 in Burchard and Cornwell (2018: 13)
BCNet <- matrix(
 c(1,1,0,0,
   1,0,1,0,
   1,0,0,1,
   0,1,1,1),
 nrow = 4, ncol = 4, byrow = TRUE)
colnames(BCNet) <- c("1", "2", "3", "4")
rownames(BCNet) <- c("i", "j", "k", "m")
#library(sna) #To plot the two mode network, we use the sna R package
#gplot(BCNet, usearrows = FALSE,
#      gmode = "twomode", displaylabels = TRUE)
computeBCConstraint(BCNet)

#For this example, we recreate Figure 9 in Burchard and Cornwell (2018:18) for
#weighted two mode networks.
BCweighted <- matrix(c(1,2,1, 1,0,0,
                      0,2,1,0,0,1),
                    nrow = 4, ncol = 3,
                    byrow = TRUE)
rownames(BCweighted) <- c("i", "j", "k", "l")
computeBCConstraint(BCweighted, weighted = TRUE)




}
\references{
Burchard, Jake and Benjamin Cornwell. 2018. "Structural Holes and Bridging
in Two-Mode Networks." \emph{Social Networks} 55:11-20.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
