% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logodds_fn.R
\name{bca_logodds}
\alias{bca_logodds}
\title{Compute a BCa bootstrap confidence interval for the weighted mean. The code is 
based on the slides found here: http://users.stat.umn.edu/~helwig/notes/bootci-Notes.pdf}
\usage{
bca_logodds(
  treat,
  covar,
  out,
  nboot,
  treat_form,
  out_levels,
  out_form,
  out_model,
  logodds_est,
  alpha = 0.05
)
}
\arguments{
\item{treat}{A \code{numeric} vector containing treatment status. Should only assume 
a value 0 or 1.}

\item{covar}{A \code{data.frame} containing the covariates to include in the working
proportional odds model.}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{nboot}{Number of bootstrap replicates used to compute bootstrap confidence
intervals.}

\item{treat_form}{The right-hand side of a regression formula for the working model of
treatment probability as a function of covariates}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}

\item{out_form}{The right-hand side of a regression formula for the working proportional 
odds model. NOTE: THIS FORMULA MUST NOT SUPPRESS THE INTERCEPT.}

\item{out_model}{Which R function should be used to fit the proportional odds 
model. Options are \code{"polr"} (from the \code{MASS} package), 
"vglm" (from the \code{VGAM} package), or \code{"clm"} (from the \code{ordinal} package).}

\item{logodds_est}{The estimated log-odds.}

\item{alpha}{Level of confidence interval.}
}
\value{
matrix with treatment-specific log-odds CIs and CI for difference.
}
\description{
Compute a BCa bootstrap confidence interval for the weighted mean. The code is 
based on the slides found here: http://users.stat.umn.edu/~helwig/notes/bootci-Notes.pdf
}
