% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimateQ_loop}
\alias{estimateQ_loop}
\title{estimateQ_loop}
\usage{
estimateQ_loop(validRows, Y, A, W, DeltaA, DeltaY, verbose, returnModels, SL_Q,
  a_0, stratify, glm_Q, family, use_future, se_cv, se_cvFolds)
}
\arguments{
\item{validRows}{A \code{list} of length \code{cvFolds} containing the row
indexes of observations to include in validation fold.}

\item{Y}{A vector of continuous or binary outcomes.}

\item{A}{A vector of binary treatment assignment (assumed to be equal to 0 or
1)}

\item{W}{A \code{data.frame} of named covariates}

\item{DeltaA}{Indicator of missing treatment (assumed to be equal to 0 if
missing 1 if observed)}

\item{DeltaY}{Indicator of missing outcome (assumed to be equal to 0 if
missing 1 if observed)}

\item{verbose}{A boolean indicating whether to print status updates.}

\item{returnModels}{A boolean indicating whether to return model fits for the
outcome regression, propensity score, and reduced-dimension regressions.}

\item{SL_Q}{A vector of characters or a list describing the Super Learner
library to be used for the outcome regression. See
\code{\link[SuperLearner]{SuperLearner}} for details.}

\item{a_0}{A list of fixed treatment values.}

\item{stratify}{A \code{boolean} indicating whether to estimate the outcome
regression separately for different values of \code{A} (if \code{TRUE}) or
to pool across \code{A} (if \code{FALSE}).}

\item{glm_Q}{A character describing a formula to be used in the call to
\code{glm} for the outcome regression. Ignored if \code{SL_Q!=NULL}.}

\item{family}{Should be gaussian() unless called from adaptive_iptw with
binary \code{Y}.}

\item{use_future}{Boolean indicating whether to use \code{future_lapply} or
instead to just use lapply. The latter can be easier to run down errors.}

\item{se_cv}{Should cross-validated nuisance parameter estimates be used
for computing standard errors?
Options are \code{"none"} = no cross-validation is performed; \code{"partial"} =
only applicable if Super Learner is used for nuisance parameter estimates;
\code{"full"} = full cross-validation is performed. See vignette for further
details. Ignored if \code{cvFolds > 1}, since then
cross-validated nuisance parameter estimates are used by default and it is
assumed that you want full cross-validated standard errors.}

\item{se_cvFolds}{If cross-validated nuisance parameter estimates are used
to compute standard errors, how many folds should be used in this computation.
If \code{se_cv = "partial"}, then this option sets the number of folds used
by the \code{SuperLearner} fitting procedure.}
}
\description{
A helper loop function to clean up the internals of \code{drtmle}
function.
}
