% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dispensing_models.R
\name{f_fit_ki}
\alias{f_fit_ki}
\title{Model Fitting for Number of Skipped Visits}
\usage{
f_fit_ki(df, model, nreps, showplot = TRUE)
}
\arguments{
\item{df}{The subject-level dosing data, including \code{skipped} to
indicate the number of skipped visits.}

\item{model}{The count model used to analyze the number of
skipped visits, with options including
"constant", "poisson", "zero-inflated poisson", and
"negative binomial".}

\item{nreps}{The number of simulations for drawing posterior model
parameter values.}

\item{showplot}{A Boolean variable that controls whether or not to
show the fitted count bar chart. It defaults to \code{TRUE}.}
}
\value{
A list with three components:
\itemize{
\item \code{fit}: A list of results from the model fit that includes
\itemize{
\item \code{model}: The specific model used in the analysis.
\item \code{theta}: The estimated model parameters.
\item \code{vtheta}: The estimated covariance matrix of \code{theta}.
\item \code{aic}: The Akaike Information Criterion value.
\item \code{bic}: The Bayesian Information Criterion value.
}
\item \code{fit_plot}: A fitted count bar chart.
\item \code{theta}: Posterior draws of model parameters.
}
}
\description{
Fits a count model to the number of skipped visits
between two consecutive drug dispensing visits.
}
\examples{
library(dplyr)

observed <- f_dose_observed(df2, visitview2, showplot = FALSE)
vf <- observed$vf

vf <- vf \%>\% left_join(dosing_schedule_df, by = "kit")

df_ti <- vf \%>\%
  mutate(time = lead(day) - day,
         skipped = pmax(floor((time - target_days/2)/target_days), 0),
         k1 = skipped + 1) \%>\%
  filter(row_id < n())

ki_fit <- f_fit_ki(df_ti, model = "zero-inflated poisson", nreps = 200)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
