% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_ongoing_new.R
\name{f_ongoing_new}
\alias{f_ongoing_new}
\title{Observed Dosing for Ongoing and New Subjects}
\usage{
f_ongoing_new(newEvents, kit_description_df, treatment_by_drug_df, vf)
}
\arguments{
\item{newEvents}{A data frame containing the imputed event data
for both ongoing and new patients, typically obtained from
the output of the \code{getPrediction} function of the
\code{eventPred} package. It contains the following variables:
\code{draw}, \code{usubjid}, \code{arrivalTime}, \code{treatment},
\code{treatment_description}, \code{time}, \code{event},
\code{dropout}, and \code{totalTime}.}

\item{kit_description_df}{A data frame indicating the
drug and kit descriptions, including the following variables:
\code{drug}, \code{drug_name}, \code{kit}, and \code{kit_name}.
It must be specified at the design stage. It will be replaced with
the observed information at the analysis stage.}

\item{treatment_by_drug_df}{A data frame indicating the treatments
associated with each drug, including the following variables:
\code{treatment} and \code{drug}.}

\item{vf}{A data frame for subject-level drug dispensing data,
including the following variables:
\code{drug}, \code{drug_name}, \code{kit}, \code{kit_name},
\code{usubjid}, \code{treatment}, \code{treatment_description},
\code{arrivalTime}, \code{time}, \code{event}, \code{dropout},
\code{day}, \code{dose}, \code{cum_dose}, and \code{row_id}.}
}
\value{
A list with the following components:
\itemize{
\item \code{vf_ongoing}: A data frame for the observed drug dispensing
data for ongoing patients with drug dispensing records.
It includes the following variables:
\code{draw}, \code{kit}, \code{kit_name}, \code{usubjid},
\code{day}, \code{dose}, \code{arrivalTime}, \code{treatment},
\code{treatment_description}, \code{time}, and \code{totalTime}.
\item \code{vf_new}: A data frame for the randomization date for new
patients and ongoing patients with no drug dispensing records.
It includes the following variables:
\code{draw}, \code{kit}, \code{kit_name}, \code{usubjid},
\code{arrivalTime}, \code{treatment}, \code{treatment_description},
\code{time}, and \code{totalTime}.
}
}
\description{
Prepares the dosing data sets to impute for ongoing and
new subjects.
}
\examples{

\donttest{
set.seed(2000)

pred <- eventPred::getPrediction(
  df = df2,
  to_predict = "event only",
  target_d = 250,
  event_model = "log-logistic",
  dropout_model = "none",
  pilevel = 0.95,
  nyears = 1,
  nreps = 200,
  showplot = FALSE,
  by_treatment = TRUE)

observed <- f_dose_observed(df = df2, visitview = visitview2)

vf_ongoing_new <- f_ongoing_new(
  pred$event_pred$newEvents,
  observed$kit_description_df,
  observed$treatment_by_drug_df,
  observed$vf)

head(vf_ongoing_new$vf_ongoing)
head(vf_ongoing_new$vf_new)
}

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
