% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simoff.R
\name{simoff}
\alias{simoff}
\title{simulating dataset (Offline settings)}
\usage{
simoff(
  n = 100,
  I = 100,
  size = 2,
  Inew = 10,
  B1 = matrix(c(-0.3, 0.4, 0.4, 0.5), ncol = size, byrow = TRUE),
  varcov = diag(2),
  B1new = matrix(c(-0.3, 0.4, 0.4, 0.5), ncol = size, byrow = TRUE)
)
}
\arguments{
\item{n}{number of time-instants}

\item{I}{number of in control batch samples}

\item{size}{number of variables}

\item{Inew}{number of new batch samples for monitoring}

\item{B1}{matrix (size x size) containing the VAR(1) coefficients of in control batches}

\item{varcov}{covariance matrix (size x size) of errors}

\item{B1new}{matrix (size x size) containing the VAR(1) coefficients of new batches}
}
\value{
\code{data}  A dataframe of reference dataset of \code{I} in control batches.
For each batch, variables are arranged in lines and columns are time-instants. The different batches are combined in a single dataset
of dimension \code{[(I * size) X n]}

\code{newdata}  A dataframe including a dataset of \code{Inew} new batches for monitoring (each with same number of variables
and time-instants of \code{data}).
The different batches are combined in a single dataset of dimension \code{[(Inew * size) X n]}
}
\description{
Function to simulate datasets based on the VAR(1) model (without intercept). The dataset include in control
batches and new batches for offline monitoring
}
\examples{

# Example 1: Two variables (A default in control simulating dataset)


    mydata=simoff()


# Example 2: Three variables and Inew=50 out of control batches

    B1=matrix(c(-0.3,0,0.4,0,0.2,0,0,-0.1,0.5),3,byrow=TRUE)
    B1new=matrix(c(0.1,0,0.4,0,0.2,0,0,-0.1,0.5),3,byrow=TRUE)
    mydata1=simoff(n=100,I=100,size=3,Inew=50,B1,varcov=diag(3),B1new)


# Example 3: Three variables and Inew=1 new out of control batch

    B1=matrix(c(-0.3,0,0.4,0,0.2,0,0,-0.1,0.5),3,byrow=TRUE)
    B1new=matrix(c(0.1,0,0.4,0,0.2,0,0,-0.1,0.5),3,byrow=TRUE)
    mydata2=simoff(n=100,I=100,size=3,Inew=1,B1,varcov=diag(3),B1new)
    plot.ts(t(mydata2$data[1:3,]),main="One in control batch sample")
    plot.ts(t(mydata2$newdata),main="One new batch sample")

}
\seealso{
offlinem, simon, onlinem
}
