% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simon.R
\name{simon}
\alias{simon}
\title{simulating dataset (Online settings)}
\usage{
simon(
  n = 100,
  I = 200,
  size = 2,
  Inew = 5,
  n1 = 50,
  B1 = matrix(c(-0.3, 0.4, 0.4, 0.5), ncol = size, byrow = TRUE),
  varcov = diag(2),
  B1new = matrix(c(-0.3, 0.4, 0.4, 0.5), ncol = size, byrow = TRUE)
)
}
\arguments{
\item{n}{number of time-instants}

\item{I}{number of in control batch samples}

\item{size}{number of variables}

\item{Inew}{number of new batch samples for monitoring}

\item{n1}{number of time-instants for the new batches under the in control process}

\item{B1}{matrix (size x size) containing the VAR(1) coefficients of in control batches}

\item{varcov}{covariance matrix (size x size) of errors}

\item{B1new}{matrix (size x size) containing the VAR(1) coefficients of new batches}
}
\value{
\code{data}  A dataframe of reference dataset of \code{I} in control batches.
For each batch, variables are arranged in lines and columns are time-instants. The different batches are combined in a single dataset
of dimension \code{[(I * size) X n]}

\code{newdata}  A dataframe including a dataset of \code{Inew} new batches for monitoring (each with same number of variables and time-instants of \code{data}).
The different batches are combined in a single dataset of dimension \code{[(Inew * size) X n]}
}
\description{
Function to simulate datasets based on the VAR(1) model (without intercept). The dataset include in control batches and new batches for online monitoring
}
\examples{

# Example 1: Two variables (A default in control simulating dataset)

    mydata=simon()


# Example 2: Three variables and Inew=5 out of control batches

    B1=matrix(c(-0.3,0,0.4,0,0.2,0,0,-0.1,0.5),3,byrow=TRUE)
    B1new=matrix(c(0.1,0,0.4,0,0.2,0,0,-0.1,0.5),3,byrow=TRUE)
    mydata1=simon(n=100,I=200,size=3,Inew=5,n1=50,B1,varcov=diag(3),B1new)


# Example 3: Three variables and one Inew=1 out of control batch

    B1=matrix(c(-0.3,0,0.4,0,0.2,0,0,-0.1,0.5),3,byrow=TRUE)
    B1new=matrix(c(0.1,0,0.4,0,0.7,0,0,-0.1,0.5),3,byrow=TRUE)
    mydata2=simon(n=100,I=1,size=3,Inew=1,n1=25,B1,varcov=diag(3),B1new)
    plot.ts(t(mydata2$data),main="One in control batch sample")
    plot.ts(t(mydata2$newdata),main="One new batch sample")

}
\seealso{
onlinem, simoff, offlinem
}
