% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCV.R
\name{plotCV}
\alias{plotCV}
\title{Plot Cyclic Voltammograms}
\usage{
plotCV(filenames = list(file1 = NULL, file2 = NULL), legend_text = NULL,
  legend_position = c("topleft", "topright", "bottomleft", "bottomright"),
  main_title = NULL, line_widths = c(2, 2, 2, 2, 2), line_types = c(1, 2,
  3, 4, 5), point_symbols = c(21, 22, 23, 24, 25), line_colors = c("blue",
  "blue", "blue", "blue", "blue"))
}
\arguments{
\item{filenames}{A list giving the names of 1--5 files that contain the results of a simulated cyclic voltammetry experiment.}

\item{legend_text}{Optional vector that contains text to include in a legend. Default is NULL, which surpresses the legend.}

\item{legend_position}{One of \code{topleft}, \code{topright}, \code{bottomleft}, or \code{bottomright}; defaults to \code{topleft}.}

\item{main_title}{An optional main title.}

\item{line_widths}{A vector of line widths for the individual cyclic voltammograms; defaults to a common line width of 2, but can be adjusted by supplying a vector with desired values.}

\item{line_types}{A vector of line types for the individual cyclic voltammograms; defaults to a set of different line types, but can be adjusted by supplying a vector with desired values.}

\item{point_symbols}{A vector of pch values for plotting points.}

\item{line_colors}{A vector of colors for the individual cyclic voltammograms, whether displayed as lines or as points; defaults to a common color, but can be adjusted by supplying a vector with desired values.}
}
\value{
Returns a plot that shows the applied potential on the \emph{x}-axis and current on the \emph{y}-axis.
}
\description{
Plots 1--5 cyclic voltammograms on a single set of axes. The
default plot does not include a legend or a title, but
providing a vector of character strings to legend_text adds a
legend to the final plot, and adding a character string for
main_title adds a title to the plot. Line widths, line types,
line colors, point symbols, and point colors have default
values that can be adjusted. Note: this function accepts both
full data files created using \code{cvSim} or reduced data
files created \code{sampleCV}.
}
\examples{

cv_ex1 = simulateCV(ko = 1, e.switch = -0.8, e.form = -0.4,
   x.units = 100, t.units = 1000)
cv_ex2 = simulateCV(ko = 0.01, e.switch = -0.8, e.form = -0.4,
  x.units = 100, t.units = 1000)
cv_ex3 = simulateCV(ko = 0.001, e.switch = -0.8, e.form = -0.4,
  x.units = 100, t.units = 1000)
cv_ex4 = simulateCV(ko = 0.0001, e.switch = -0.8, e.form = -0.4,
  x.units = 100, t.units = 1000)
plotCV(filenames = list(cv_ex1, cv_ex2, cv_ex3, cv_ex4),
  legend_text = c("ko = 1 cm/s", "ko = 0.01 cm/s",
  "ko = 0.001 cm/s", "ko = 0.0001 cm/s"))

cv_ex1sample = sampleCV(cv_ex1, data.reduction = 5)
plotCV(filenames = list(cv_ex1, cv_ex1sample),
  line_colors = c("blue", "red"))
}
