% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fred.R
\name{fred}
\alias{fred}
\title{Fetch Data Series from FRED}
\usage{
fred(
  ...,
  key = NULL,
  all = TRUE,
  info = TRUE,
  realtime_start = NULL,
  realtime_end = NULL,
  long = FALSE
)
}
\arguments{
\item{...}{character vectors of series ids to search. Any names will be used to label the series in the resulting data.frame}

\item{key}{32 character lower-cased alpha-numeric character string}

\item{all}{logical; should all observations be used? Defaults to \code{TRUE}. If \code{FALSE}, only observations existing in all series will be kept.}

\item{info}{logical; should information about each series, such as units and title, be kept? If so, the information will be stored in a data.frame under the attribute \code{"info"}.}

\item{realtime_start, realtime_end}{character date strings of format "YYY-MM-DD" used obtain information that was known during the specified time period. If empty, the latest update of the information is used.}

\item{long}{logical; should the resulting data.frame be long or wide? Defaults to \code{FALSE} so that a new column is created for each series}
}
\value{
data.frame
}
\description{
Function that fetches economic data from the FRED based on the series ids.
}
\details{
The \code{fred} function search for series ids from the FRED and returns the
values in a data.frame. Unless \code{long=TRUE}, a new column will be created
for each series. The dates for each observation will be included in the \code{"date"}
column and will be of class "Date". Each series will be a numeric value.

If a series cannot be found, then it will be skipped and R will issue a warning.

To access ALFRED, or the archived Federal Reserve Economic Data, use the \code{realtime_start}
and \code{realtime_end} arguments to specify a time frame. More details about
real time periods can be found at \url{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}.
}
\examples{
\dontrun{
api_key <- "abcdefghijklmnopqrstuvwxyz123456"

# Naive Phillips Curve Estimation
df <- fred(p = "CPIAUCSL", u = "u6rate", key=api_key)
head(df)

df$pi  <- log(df$p) - log(c(NA, df$p[2:nrow(df)]))
reg_pc <- lm(pi ~ u, data = df)
summary(reg_pc)

# Different variations of the CPI
cpis <- c("CPIMEDSL", "CPIFABSL", "CPIHOSSL")
names(cpis) <- c("P_Med", "P_Food", "P_House")

df_cpi <- fred(cpis, key=api_key, long=TRUE)
head(df)
}
}
