% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fred_release.R
\name{fred_releases}
\alias{fred_releases}
\alias{fred_releases_dates}
\alias{fred_release}
\alias{fred_release_dates}
\alias{fred_release_series}
\alias{fred_release_sources}
\alias{fred_release_tags}
\alias{fred_release_related_tags}
\alias{fred_release_tables}
\title{Fetch Information on a Release in FRED}
\usage{
fred_releases(key = NULL, args = list())

fred_releases_dates(key = NULL, args = list())

fred_release(..., key = NULL, args = list())

fred_release_dates(..., key = NULL, args = list())

fred_release_series(..., key = NULL, args = list())

fred_release_sources(..., key = NULL, args = list())

fred_release_tags(..., key = NULL, args = list())

fred_release_related_tags(..., key = NULL, args = list())

fred_release_tables(..., key = NULL, args = list())
}
\arguments{
\item{key}{32 character lower-cased alpha-numeric character string}

\item{args}{named list of other arguments passed to the API, including "limit", "offset", "sort_order", etc. See \code{\link{fred_search}} for more details on accepted parameters.}

\item{...}{character or numeric vectors of release ids to search}
}
\value{
data.frame with entries described in details
}
\description{
Each of the functions accept a release name/number and return the requested information in a data.frame.
}
\details{
Each function returns the following information in a data.frame.

\describe{
 \item{\code{fred_releases}}{Release id, its name, a url link, whether there is a press release, and realtime start and end dates}
 \item{\code{fred_releases_dates}}{Release id, its name, and date of release}
 \item{\code{fred_release}}{Release id, its name, a url link, whether there is a press release, and realtime start and end dates}
 \item{\code{fred_release_dates}}{Release id and its release date}
 \item{\code{fred_release_series}}{Series id, its title, observations start and end, frequency, units, seasonal adjustment type, popularity, realtime start and end, and when it was last updated}
 \item{\code{fred_release_sources}}{Source id, name of source, url link, and realtime start and end dates}
 \item{\code{fred_release_tags}}{Tag name and its group id, popularity of tag, number of series in each tag, when it was created, and other notes}
 \item{\code{fred_release_related_tags}}{Same as \code{fred_release_tags}}
 \item{\code{fred_release_tables}}{Release, element, parent, and series ids, type, and name}
}
}
\section{Functions}{
\itemize{
\item \code{fred_releases}: get all releases of economic data

\item \code{fred_releases_dates}: get the dates of all economic releases

\item \code{fred_release}: get information about a particular release

\item \code{fred_release_dates}: get release dates for a particular release

\item \code{fred_release_series}: get all series associated with a particular release

\item \code{fred_release_sources}: get the sources associated with a particular release

\item \code{fred_release_tags}: get all tags associated with a particular release

\item \code{fred_release_related_tags}: get all related tags associated with a particular release

\item \code{fred_release_tables}: get the release tables for a particular release
}}

