% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_acdsim.R
\docType{methods}
\name{pc_acdsim-class}
\alias{pc_acdsim-class}
\alias{pc_acdsim}
\alias{pc_acdsim-methods}
\alias{pc_acdsim,ANY-method}
\title{A method to simulate nonstationary ACD models.}
\usage{
pc_acdsim(object)

\S4method{pc_acdsim}{ANY}(object)
}
\arguments{
\item{object}{a simACD object}
}
\value{
Returns an object of \code{simACD} class containing a simulated piecewise constant ACD time series.
}
\description{
A S4 method that takes as an input a \code{simACD} object and outputs a simulated nonstationary ACD(1,1) model. The formulation of the of the
piecewise constant ACD model is given in the \code{simACD} class.
}
\examples{
pw.acd.obj <- new("simACD")
pw.acd.obj@cp.loc <- c(0.25,0.75)
pw.acd.obj@lambda_0 <- c(1,2,1)
pw.acd.obj@alpha <- rep(0.2,3)
pw.acd.obj@beta <- rep(0.7,3)
pw.acd.obj@N <- 3000
pw.acd.obj <- pc_acdsim(pw.acd.obj)
ts.plot(pw.acd.obj@x)
ts.plot(pw.acd.obj@psi)
}
\references{
Korkas, K.K., 2022. Ensemble binary segmentation for irregularly spaced data with change-points. Journal of the Korean Statistical Society, 51(1), pp.65-86.
}
